IF  EXISTS (SELECT 1 FROM sys.indexes WHERE name = ('IX_EST_PROD_TRANSF_STATUS'))
	DROP INDEX [IX_EST_PROD_TRANSF_STATUS] ON [dbo].[EST_PROD_TRANSF]
GO

/*
=======================================================================================
'Nvel Classificao.: INFORMAO RESTRITA
'Verso..............: 20230323
'Job.................:  
'Nome................: IX_EST_PROD_TRANSF_STATUS
'Objetivo............: Melhorar desempenho na consulta da proc P_INCLUI_PENDENCIA_WMS do step Incluir pendencia ressup. WMS do job de ressuprimento
'Tabelas.............: 
'Dt Criao..........: 
'Dt Ult Alteraco....: 2023-03-23
'Alterado por........: Jerfeson Barbosa
'Criado por..........: 
'=======================================================================================
**Adicionado o campo FLAG_NAO_GERAR_WMS no INCLUDE do Index, pois estava realizando KeyLookup na consulta.
*/

CREATE NONCLUSTERED INDEX [IX_EST_PROD_TRANSF_STATUS] ON [dbo].[EST_PROD_TRANSF]
(
	[CD_EMP] ASC,
	[CD_FILIAL] ASC,
	[STS_TRANSF] ASC
)
INCLUDE([CD_CTR],[TP_TRANSF],[CD_FIL_DEST],[DT_TRANSF],[FLAG_CAIXA_FECHADA],[FLAG_CHECKOUT_INICIADO], FLAG_NAO_GERAR_WMS) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = ON, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 97) ON [PRIMARY]
GO






